/*	Renegade Scripts.dll
	Example Plugin Code
	Copyright 2007 Whitedragon(MDB), Jonathan Wilson

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/

#include "gmsettingsclass.h"

#define PluginName "Extra Console Commands Plugin"
#define PluginVersion "1.0"

void Plugin_Load();
void Plugin_Unload();


class ConsoleCommand
{
public:
	virtual const char *GetName() = 0;
	virtual const char *GetAlias() = 0;
	virtual const char *GetHelp() = 0;
	virtual void Activate(const char *CommandLine) = 0;
	virtual ~ConsoleCommand();
	static void InstallCommands();
	ConsoleCommand();
};

class ConsoleCommand_changecharacter : public ConsoleCommand {
public:
	virtual const char *GetName();
	virtual const char *GetAlias();
	virtual const char *GetHelp();
	virtual void Activate(const char *CommandLine);
};

class ConsoleCommand_freeze : public ConsoleCommand {
public:
	virtual const char* GetName();
	virtual const char* GetAlias();
	virtual const char* GetHelp();
	virtual void Activate(const char* CommandLine);

};

class ConsoleCommand_flymode : public ConsoleCommand {
public:
	virtual const char* GetName();
	virtual const char* GetAlias();
	virtual const char* GetHelp();
	virtual void Activate(const char* CommandLine);

};



class ConsoleCommand_givepoints : public ConsoleCommand {
public:
	virtual const char *GetName();
	virtual const char *GetAlias();
	virtual const char *GetHelp();
	virtual void Activate(const char *CommandLine);
};

class ConsoleCommand_kill : public ConsoleCommand {
public:
	virtual const char *GetName();
	virtual const char *GetAlias();
	virtual const char *GetHelp();
	virtual void Activate(const char *CommandLine);
};

class ConsoleCommand_refund : public ConsoleCommand {
public:
	virtual const char *GetName();
	virtual const char *GetAlias();
	virtual const char *GetHelp();
	virtual void Activate(const char *CommandLine);
};

class ConsoleCommand_setcredits : public ConsoleCommand {
public:
	virtual const char *GetName();
	virtual const char *GetAlias();
	virtual const char *GetHelp();
	virtual void Activate(const char *CommandLine);
};

class ConsoleCommand_setpoints : public ConsoleCommand {
public:
	virtual const char *GetName();
	virtual const char *GetAlias();
	virtual const char *GetHelp();
	virtual void Activate(const char *CommandLine);
};

class ConsoleCommand_teleport : public ConsoleCommand {
public:
	virtual const char *GetName();
	virtual const char *GetAlias();
	virtual const char *GetHelp();
	virtual void Activate(const char *CommandLine);
};

class ConsoleCommand_unfreeze : public ConsoleCommand {
public:
	virtual const char* GetName();
	virtual const char* GetAlias();
	virtual const char* GetHelp();
	virtual void Activate(const char* CommandLine);

};

extern int *CommandsCount;
extern ConsoleCommand *CommandsArray;

typedef void (*_SortCommands)();
extern _SortCommands SortCommands;

typedef void (*_UpdateCommands)();
extern _UpdateCommands UpdateCommands;
